/** !------------------------------------------------------------------------->
*
*  @file Rte_generated.c
*
*  @creationDate 21 November 2024 16:54:49
*
*  @brief Generated Rte configuration source file.
*
*  @author
*
*  @description
*
*  @copyright
*    Copyright 2024, dSPACE GmbH. All rights reserved.
*
*  @version
*
*   <hr><br>
*!-------------------------------------------------------------------------->*/

#include "Rte_generated.h"
#include <string.h>
#include <float.h>
#include <limits.h>
#include "StateManager_generated.h"
#include "ScalingFunctions.h"




/**************************************************************************************************\
 *** FUNCTION:
 ***    Rte_COMCbk_RxPDU
 *** 
 *** DESCRIPTION:
 ***     Callback for the COM Module to indicate the reception of a PDU.
 ***     This is a non AUTOSAR standard callback function and is used to optimize the
 ***     trace access to physical signal values. Using the callback the scaling algorithm 
 ***     only needs to be executed whenever a new signal value is received, removing the necessity to
 ***     poll COM signal values for trace access.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     PduIdType       ComRxPduId       ID of the received pdu.
 ***                                     
 *** 
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
static UNUSED void Rte_COMCbk_RxPDU(PduIdType ComRxPduId)
{
    INTENDED_UNREFERENCED_PARAMETER(ComRxPduId);
}

/*------------------------------------------------------------------------------------------------*\
  FUNCTION PROTOTYPES
\*------------------------------------------------------------------------------------------------*/

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_VariableInitialize
 *** 
 *** DESCRIPTION:
 ***    This function is called before the application starts and may be used to extend the
 ***    initialization phase. Depending on InitialValueUsage parameter, it is called either in OnInit
 ***    or OnStart application phase.
 *** PARAMETERS:
 *** 
 *** RETURNS:
 ***     void
\**************************************************************************************************/
void Rte_VariableInitialize(void)
{
    /* Initialization of the TX signals and triggers */
    /* Signal: Inst_1_cmd_battery_pump */
    Com_TX_Inst_1_cmd_battery_pump_11187_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_2_cmd_chiller_bypass */
    Com_TX_Inst_2_cmd_chiller_bypass_11186_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_3_cmd_comp */
    Com_TX_Inst_3_cmd_comp_11185_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_4_cmd_fan */
    Com_TX_Inst_4_cmd_fan_11184_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_5_cmd_heater */
    Com_TX_Inst_5_cmd_heater_11183_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_6_cmd_motor_pump */
    Com_TX_Inst_6_cmd_motor_pump_11182_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_7_cmd_parallel_serial */
    Com_TX_Inst_7_cmd_parallel_serial_11181_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_8_cmd_rad_bypass */
    Com_TX_Inst_8_cmd_rad_bypass_11180_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_11_I_traction */
    Com_TX_Inst_11_I_traction_11177_10693_11337_sgn_val = (sint16)0/*0x0*/;
    /* Signal: Inst_15_Q_charger */
    Com_TX_Inst_15_Q_charger_11173_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_16_Q_dcdc */
    Com_TX_Inst_16_Q_dcdc_11172_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_17_Q_inverter */
    Com_TX_Inst_17_Q_inverter_11171_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_18_Q_motor */
    Com_TX_Inst_18_Q_motor_11170_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_28_v_vehicle */
    Com_TX_Inst_28_v_vehicle_11160_10693_11337_sgn_val = (uint16)0;

    /* Initialization of the RX signals and triggers */
    /* Signal: Inst_0_AngVel_Compressor */
    Com_RX_Inst_0_AngVel_Compressor_11188_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_9_EPower_Compressor */
    Com_RX_Inst_9_EPower_Compressor_11179_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_10_i_battery */
    Com_RX_Inst_10_i_battery_11178_10693_11337_sgn_val = (sint16)0/*0x0*/;
    /* Signal: Inst_12_p_chiller */
    Com_RX_Inst_12_p_chiller_11176_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_13_p_cond */
    Com_RX_Inst_13_p_cond_11175_10693_11337_sgn_val = (uint8)0;
    /* Signal: Inst_14_PJoule_battery */
    Com_RX_Inst_14_PJoule_battery_11174_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_19_T_battery1 */
    Com_RX_Inst_19_T_battery1_11169_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_20_T_battery2 */
    Com_RX_Inst_20_T_battery2_11168_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_21_T_battery3 */
    Com_RX_Inst_21_T_battery3_11167_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_22_T_battery4 */
    Com_RX_Inst_22_T_battery4_11166_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_23_T_coolant_battery_in */
    Com_RX_Inst_23_T_coolant_battery_in_11165_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_24_T_coolant_inverter_out */
    Com_RX_Inst_24_T_coolant_inverter_out_11164_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_25_T_inverter */
    Com_RX_Inst_25_T_inverter_11163_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_26_T_motor */
    Com_RX_Inst_26_T_motor_11162_10693_11337_sgn_val = (uint16)0;
    /* Signal: Inst_27_Torque_Compressor */
    Com_RX_Inst_27_Torque_Compressor_11161_10693_11337_sgn_val = (uint16)0;

}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_SetPhysicalValue
 *** 
 *** DESCRIPTION:
 ***     Calculates a new physical value, if the coded value has changed.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     boolean           always         Flag which enforces calculation even if the coded signal did not change.
 ***                                      This behavior is used for initialization during startup
 *** 
\**************************************************************************************************/
void Rte_SetPhysicalValue(Rte_SignalIdType SignalId, boolean always)
{
    POSSIBLE_UNREFERENCED_PARAMETER(SignalId);
    POSSIBLE_UNREFERENCED_PARAMETER(always);

}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_SetCodedValue
 *** 
 *** DESCRIPTION:
 ***     Calculates a new coded value, if the physical value has changed.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     boolean           always         Flag which enforces calculation even if the physical signal did not change.
 *** 
 *** RETURNS:
 ***     boolean  Flag which inidcates that a calculation was performed and the underlying 
 ***              PDU has to be updated.
 \**************************************************************************************************/
boolean Rte_SetCodedValue(Rte_SignalIdType SignalId, boolean always)
{
    POSSIBLE_UNREFERENCED_PARAMETER(SignalId);
    POSSIBLE_UNREFERENCED_PARAMETER(always);

    return FALSE;
}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_WriteSignal
 *** 
 *** DESCRIPTION:
 ***     Updates the signal object identified by SignalId with the signal referenced by the
 ***     SignalDataPtr.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be sent.
 ***     const void *      SignalDataPtr  Reference to the signal data to store the received data in.
 *** 
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
uint8 Rte_WriteSignal(Rte_SignalIdType SignalId, const void * SignalDataPtr)
{
    POSSIBLE_UNREFERENCED_PARAMETER(SignalId);
    POSSIBLE_UNREFERENCED_PARAMETER(SignalDataPtr);

    return RTE_NO_SUCH_SIGNAL;

}

/**************************************************************************************************\
 *** FUNCTION:
 ***     Rte_ReadSignal
 *** 
 *** DESCRIPTION:
 ***     The function copies the content of the associated shadow buffer to the given memory location
 ***     and performs signal conversion.
 *** 
 *** PARAMETERS:
 ***     Type              Name           Description
 ***     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 ***     Rte_SignalIdType  SignalId       RTE Signal ID of signal to be read.
 ***     void *            SignalDataPtr  Reference to the signal data to store the received data in.
 *** 
 *** RETURNS:
 ***     uint8    The status code of the function call.
\**************************************************************************************************/
uint8 Rte_ReadSignal(Rte_SignalIdType SignalId, void * SignalDataPtr)
{
    POSSIBLE_UNREFERENCED_PARAMETER(SignalId);
    POSSIBLE_UNREFERENCED_PARAMETER(SignalDataPtr);


    return RTE_NO_SUCH_SIGNAL;
}

